Ext.data.JsonP.sol_common_ix_DynKwlMixin({"tagname":"class","name":"sol.common.ix.DynKwlMixin","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"requires":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ix.DynKwlUtils.js","href":"lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin"}],"author":[{"tagname":"author","name":"PZ, ELO Digital Office GmbH","email":null}],"version":["1.03.000"],"eloix":true,"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"requires":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"mixin","tagname":"property","owner":"sol.common.ix.DynKwlMixin","id":"property-mixin","meta":{"private":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"formatNumber","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatNumber","meta":{"private":true}},{"name":"formatRow","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-formatRow","meta":{"protected":true}},{"name":"getTableKeyNames","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-getTableKeyNames","meta":{"protected":true}},{"name":"initialize","tagname":"method","owner":"sol.common.ix.DynKwlMixin","id":"method-initialize","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.ix.DynKwlMixin","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":["sol.common.ix.DynKwlBLPIterator","sol.common.ix.DynKwlDatabaseIterator","sol.common.ix.DynKwlSearchIterator"],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ix.DynKwlMixin</strong></div></div><h4>Mixed into</h4><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlBLPIterator' rel='sol.common.ix.DynKwlBLPIterator' class='docClass'>sol.common.ix.DynKwlBLPIterator</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlDatabaseIterator' rel='sol.common.ix.DynKwlDatabaseIterator' class='docClass'>sol.common.ix.DynKwlDatabaseIterator</a></div><div class='dependency'><a href='#!/api/sol.common.ix.DynKwlSearchIterator' rel='sol.common.ix.DynKwlSearchIterator' class='docClass'>sol.common.ix.DynKwlSearchIterator</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin' target='_blank'>lib_sol.common.ix.DynKwlUtils.js</a></div></pre><div class='doc-contents'><p>Helper functions for the dynamic keywordlist iterators.</p>\n      <p class='version-tag'>Version: <b>1.03.000</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div><div id='property-mixin' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlMixin'>sol.common.ix.DynKwlMixin</span><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-property-mixin' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-property-mixin' class='name expandable'>mixin</a> : Boolean<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<p>Defaults to: <code>true</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-formatNumber' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlMixin'>sol.common.ix.DynKwlMixin</span><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatNumber' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatNumber' class='name expandable'>formatNumber</a>( <span class='pre'>value, params</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Formats decimal numbers using sol.common.Locale.formatDecimal. ...</div><div class='long'><p>Formats decimal numbers using <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>value</span> : String<div class='sub-desc'>\n</div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-formatRow' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlMixin'>sol.common.ix.DynKwlMixin</span><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-formatRow' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-formatRow' class='name expandable'>formatRow</a>( <span class='pre'>row</span> )<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Uses this.formatting to apply formatting to a table row. ...</div><div class='long'><p>Uses <code>this.formatting</code> to apply formatting to a table row.</p>\n\n<h1>Format decimal</h1>\n\n<p>See also <a href=\"#!/api/sol.common.Locale-method-formatDecimal\" rel=\"sol.common.Locale-method-formatDecimal\" class=\"docClass\">sol.common.Locale.formatDecimal</a>.</p>\n\n<pre><code>formatting = [\n  { columnNames: [\"MY_OUTPUT_COLUMN1\"], minimumFractionDigits: 0, maximumFractionDigits: 2 },\n  { columnNames: [\"MY_OUTPUT_COLUMN2\", \"ANOTHER_OUTPUT_COLUMN\"], maximumFractionDigits: 4 }\n];\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>row</span> : String[]<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-getTableKeyNames' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlMixin'>sol.common.ix.DynKwlMixin</span><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-getTableKeyNames' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-getTableKeyNames' class='name expandable'>getTableKeyNames</a>( <span class='pre'>focusFieldName</span> ) : String[]<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Determines the table keys for the output of the dynamic kwl. ...</div><div class='long'><p>Determines the table keys for the output of the dynamic kwl.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>focusFieldName</span> : String<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ix.DynKwlMixin'>sol.common.ix.DynKwlMixin</span><br/><a href='source/lib_sol.common.ix.DynKwlUtils.html#sol-common-ix-DynKwlMixin-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ix.DynKwlMixin-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a></p></div></div></div></div></div></div></div>","meta":{"eloix":true}});